
uniform sampler2D u_texture;
uniform mediump vec4 u_filterInfo;

varying lowp vec4 v_fragmentColor;
varying highp vec2 v_texCoord;

void main()
{
	mediump vec2 texelCoord = v_texCoord / u_filterInfo.zw;
	mediump vec2 fraction = fract(texelCoord);
	if (fraction.x < u_filterInfo.x / 2)
		fraction.x /= u_filterInfo.x;
	else if (fraction.x > 1 - u_filterInfo.x / 2)
		fraction.x = 1 - (1 - fraction.x) / u_filterInfo.x;
	else
		fraction.x = 0.5;
	if (fraction.y < u_filterInfo.y / 2)
		fraction.y /= u_filterInfo.y;
	else if (fraction.y > 1 - u_filterInfo.y / 2)
		fraction.y = 1 - (1 - fraction.y) / u_filterInfo.y;
	else
		fraction.y = 0.5;
		
	gl_FragColor = v_fragmentColor * texture2D(u_texture, (floor(texelCoord) + fraction) * u_filterInfo.zw);
}
